<?php
session_start();

// Validar sesión
if (!isset($_SESSION["id_usuario"])) {
    header("Location: login.php");
    exit();
}

require 'db.php';

$recepcion = null;
$detalle = [];
$mensaje = "";
$mensaje_exito = "";

// Proceso para aprobar la recepción
if (isset($_POST['aprobar']) && isset($_POST['id_recepcion'])) {
    $id_recepcion = intval($_POST['id_recepcion']);
    $usuario_aprueba = $_SESSION['nombre'];
    $fecha_actual = date("Y-m-d H:i:s");

    $stmt = $conn->prepare("UPDATE recepcion_general 
        SET status = 'APROBADO', aprobado_por = ?, fecha_aprobacion = ?
        WHERE id_recepcion = ?");
    $stmt->bind_param("ssi", $usuario_aprueba, $fecha_actual, $id_recepcion);

    if ($stmt->execute()) {
	


        $mensaje_exito = "✅ La recepción fue aprobada correctamente.";
    } else {
        $mensaje = "❌ Error al aprobar la recepción: " . $stmt->error;
    }
    $stmt->close();
}

// Buscar recepción por control
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['control'])) {
    $control = trim($_POST['control']);

    if ($control !== "") {
        $stmt = $conn->prepare("
            SELECT rg.*, p.razon_social AS proveedor_nombre 
            FROM recepcion_general rg 
            LEFT JOIN proveedor p ON rg.rif_proveedor = p.cedula 
            WHERE rg.control = ?
        ");
        $stmt->bind_param("s", $control);
        $stmt->execute();
        $result = $stmt->get_result();
        $recepcion = $result->fetch_assoc();
        $stmt->close();

        if ($recepcion) {
            $stmt = $conn->prepare("
                SELECT descripcion, cantidad, peso_bruto, peso_tara, peso_neto 
                FROM detalle_recepcion 
                WHERE id_recepcion = ?
            ");
            $stmt->bind_param("i", $recepcion['id_recepcion']);
            $stmt->execute();
            $detalle = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            $stmt->close();
        } else {
            $mensaje = "No se encontró una recepción con ese número de control.";
        }
    } else {
        $mensaje = "Debe ingresar un número de control.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Aprobar Recepción</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4fff6;
      padding: 30px;
    }
    .container {
      max-width: 1100px;
      margin: auto;
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32;
      margin-bottom: 20px;
    }
    label {
      font-weight: 500;
    }
    input[type="text"] {
      padding: 8px;
      width: 300px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    .boton {
      padding: 8px 15px;
      background-color: #2e7d32;
      color: white;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      margin-left: 10px;
    }
    .boton:hover {
      background-color: #1b5e20;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 25px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 6px;
      text-align: center;
    }
    th {
      background-color: #e8f5e9;
      color: #2e7d32;
    }
    .acciones {
      margin-top: 20px;
      display: flex;
      gap: 15px;
    }
    .mensaje {
      margin-top: 15px;
      padding: 10px;
      background: #fff3cd;
      color: #856404;
      border: 1px solid #ffeeba;
      border-radius: 5px;
    }
  </style>
</head>
<body>
<div class="container">
  <h2>Buscar y Aprobar Recepción</h2>

 <form method="post" style="display: flex; align-items: center; gap: 10px;">
  <label for="control">Buscar por Control:</label>
  <input type="text" name="control" id="control" placeholder="Ej: 0000007" value="<?= isset($_POST['control']) ? htmlspecialchars($_POST['control']) : '' ?>" required>
  <button type="submit" class="boton">Buscar</button>
  <a href="aprobar_recepciones.php" class="boton" style="background-color:#9e9e9e;">Limpiar</a>
  <a href="home.php?id=<?= $recepcion['id_recepcion'] ?>" target="_blank" class="boton" style="background-color:#1976d2;">Volver</a>
</form>


  <?php if ($mensaje): ?>
    <div class="mensaje"><?= htmlspecialchars($mensaje) ?></div>
  <?php endif; ?>

  <?php if ($mensaje_exito): ?>
    <div class="alert alert-success"><?= htmlspecialchars($mensaje_exito) ?></div>
  <?php endif; ?>

  <?php if ($recepcion): ?>
    <h3>Recepción: <?= htmlspecialchars($recepcion['control']) ?></h3>
    <p><strong>Status:</strong>
  <?php if ($recepcion['status'] === 'APROBADO'): ?>
    <span style="background-color: #c8e6c9; color: #256029; padding: 5px 10px; border-radius: 5px; font-weight: bold;">
      APROBADO
    </span>
  <?php else: ?>
    <span style="background-color: #fff9c4; color: #8a6d3b; padding: 5px 10px; border-radius: 5px; font-weight: bold;">
      ABIERTO
    </span>
  <?php endif; ?>
</p>


    <p><strong>Fecha:</strong> <?= date("d/m/Y", strtotime($recepcion['fecha_recepcion'])) ?></p>
    <p><strong>Proveedor:</strong> <?= htmlspecialchars($recepcion['proveedor_nombre']) ?></p>
    <p><strong>Guía SADA:</strong> <?= htmlspecialchars($recepcion['guia_sada']) ?></p>
    <p><strong>Vehículo:</strong> <?= htmlspecialchars($recepcion['vehiculo']) ?></p>
    <p><strong>Chofer:</strong> <?= htmlspecialchars($recepcion['chofer']) ?></p>
    <p><strong>Placa Chuto:</strong> <?= htmlspecialchars($recepcion['placa_chuto']) ?></p>
    <p><strong>Placa Batea:</strong> <?= htmlspecialchars($recepcion['placa_batea']) ?></p>

    <table>
      <thead>
        <tr>
          <th>Descripción</th>
          <th>Cantidad</th>
          <th>Peso Bruto</th>
          <th>Peso Tara</th>
          <th>Peso Neto</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($detalle as $row): ?>
          <tr>
            <td><?= htmlspecialchars($row['descripcion']) ?></td>
            <td><?= number_format($row['cantidad'], 2, ',', '.') ?></td>
            <td><?= number_format($row['peso_bruto'], 2, ',', '.') ?></td>
            <td><?= number_format($row['peso_tara'], 2, ',', '.') ?></td>
            <td><?= number_format($row['peso_neto'], 2, ',', '.') ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <div class="acciones">
      <!-- Botón Aprobar que abre el modal -->
      <?php if ($recepcion['status'] === 'ABIERTO'): ?>
  <!-- Botón activo que abre el modal -->
  <button type="button" class="boton" data-bs-toggle="modal" data-bs-target="#modalConfirmar">Aprobar Recepción</button>
<?php else: ?>
  <!-- Botón desactivado si ya está aprobado -->
  <button type="button" class="boton" style="background-color:gray; cursor:not-allowed;" disabled>Recepción Aprobada</button>
<?php endif; ?>


      <!-- Botón Imprimir -->
      <a href="ticket_pesaje.php?id=<?= $recepcion['id_recepcion'] ?>" target="_blank" class="boton" style="background-color:#1976d2;">Imprimir Ticket</a>
    </div>
  <?php endif; ?>
</div>

<!-- Modal de Confirmación -->
<div class="modal fade" id="modalConfirmar" tabindex="-1" aria-labelledby="modalConfirmarLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header">
          <h5 class="modal-title" id="modalConfirmarLabel">Confirmar Aprobación</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          ¿Está seguro que desea aprobar esta recepción?
        </div>
        <div class="modal-footer">
          <input type="hidden" name="id_recepcion" value="<?= $recepcion['id_recepcion'] ?>">
          <input type="hidden" name="aprobar" value="1">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-success">Sí, Aprobar</button>
        </div>
      </form>
    </div>
  </div>
</div>

</body>
</html>
